//
//  TTTGame.m
//  Tic-Tac-Toe-Storyboard
//
//  Created by Rajiv Ramnath on 9/4/13.
//  Copyright (c) 2013 Rajiv Ramnath. All rights reserved.
//

#import "TTTGame.h"

@implementation TTTGame
	
	-(id) init { //Constructor
		gameGrid = [[TTTGameGrid alloc] init];
		gameState = Active;
		currentSymbol = [TTTSymbol SymbolXCreate];
        currentPlayer = Player1;
        return self;
	}

    - (id) initFromDictionary: (NSDictionary *) savedGameDictionary{ //Constructor from saved state
        NSString* gameGridString = [savedGameDictionary objectForKey:@TTTGAMEKEYGRIDSTATE];
        gameGrid = [[TTTGameGrid alloc] initFromString:gameGridString];
        
        NSNumber* gameStateNumber = [savedGameDictionary objectForKey:@TTTGAMEKEYSTATE];
        gameState = [gameStateNumber intValue];
        
        NSNumber* gamePlayCountNumber = [savedGameDictionary objectForKey:@TTTGAMEKEYPLAYCOUNT];
        playCount = [gamePlayCountNumber intValue];
        
        NSNumber* gameCurrentPlayerNumber = [savedGameDictionary objectForKey:@TTTGAMEKEYCURRENTPLAYER];
        currentPlayer = [gameCurrentPlayerNumber intValue];
        
        
        NSString* currentSymbolString = [savedGameDictionary objectForKey:@TTTGAMEKEYCURRENTSYMBOL];
        
        currentSymbol = [TTTSymbol CreateSymbolFromString:currentSymbolString];
        return self;
    }

	- (TTTGameGrid *) getGameGrid{
		return gameGrid;
	}

    - (void) setPlayerNames :(NSString *) FirstPlayer : (NSString *) SecondPlayer{
		PlayerOneName = FirstPlayer; PlayerTwoName = SecondPlayer;
	}

	- (NSString *) getPlayerOneName{ return PlayerOneName; }

	- (NSString *) getPlayerTwoName{ return PlayerTwoName; }

	- (NSString *) getCurrentPlayerName {
		if (currentPlayer == Player1) return PlayerOneName; else return PlayerTwoName;
	}

	- (NSString *)  getWinningPlayerName {
		if (winningPlayer == Player1) return PlayerOneName; else return PlayerTwoName;
	}

	- (TTTSymbol *) getCurrentSymbol{
		return currentSymbol;
	}

    - (void) checkResultAndSetState{
        if([gameGrid isRowFilled:0]||
           [gameGrid isRowFilled:1]||
           [gameGrid isRowFilled:2]||
           [gameGrid isColumnFilled:0]||
           [gameGrid isColumnFilled:1]||
           [gameGrid isColumnFilled:2]||
           [gameGrid isLeftToRightDiagonalFilled]||
           [gameGrid isRightToLeftDiagonalFilled]){
            winningPlayer = currentPlayer;
            gameState = Won;
        }else if (playCount==9){
            gameState = Draw;
        } /* else, leave state as is */
    }

    - (BOOL) play :(int) x :(int) y{
		BOOL successfulPlay=false;
        if ([gameGrid getValueAtLocation :x :y] == [TTTSymbol SymbolBlankCreate]){
			successfulPlay = true;
			playCount++;
            NSLog(@"Played at x=%d y=%d\n", x, y);
            [gameGrid setValueAtLocation :x :y :currentSymbol];
			[self checkResultAndSetState];
			if(gameState == Active){// if the game is still active
				// Swap symbols and players
				if(currentSymbol == [TTTSymbol SymbolXCreate]){
					currentSymbol= [TTTSymbol SymbolOCreate];
				} else {
					currentSymbol= [TTTSymbol SymbolXCreate];
                }
				if(currentPlayer == Player1) currentPlayer = Player2; else currentPlayer = Player1;
			}
		}
		return successfulPlay;
	}

	
	- (BOOL) isActive{
		return gameState == Active;
	}

	- (BOOL) isWon{
		return gameState == Won;
	}
	- (BOOL) isDrawn{
		return gameState == Draw;
	}
	- (int) getPlayCount{
		return playCount;
	}

    - (NSDictionary *) toDictionary {
        NSMutableDictionary *tempDictionary= [[NSMutableDictionary alloc] init];
        
        NSString* gameGridString = [gameGrid toString];
        [tempDictionary setObject:gameGridString forKey:@TTTGAMEKEYGRIDSTATE];
        
        NSNumber* playCountNumber = [NSNumber numberWithInteger:playCount];
        [tempDictionary setObject:playCountNumber forKey:@TTTGAMEKEYPLAYCOUNT];
        
        NSNumber* stateNumber = [NSNumber numberWithInteger:gameState];
        [tempDictionary setObject:stateNumber forKey:@TTTGAMEKEYSTATE];
        
        NSNumber* currentPlayerNumber = [NSNumber numberWithInteger:currentPlayer];
        [tempDictionary setObject:currentPlayerNumber forKey:@TTTGAMEKEYCURRENTPLAYER];
        
        NSString* currentSymbolString = [currentSymbol toString];
        [tempDictionary setObject:currentSymbolString forKey:@TTTGAMEKEYCURRENTSYMBOL];

        NSDictionary *retVal = [[NSDictionary alloc] initWithDictionary:tempDictionary];
        return retVal;
    }




@end
